// BspDlg.cpp : implementation file
//

#include "stdafx.h"
#include "version.h"
#include "rwexp.h"
#include "BspDlg.h"
#include "osutils.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CBspDlg dialog


CBspDlg::CBspDlg(CWnd* pParent /*=NULL*/)
    : CDialog(CBspDlg::IDD, pParent)
{
    //{{AFX_DATA_INIT(CBspDlg)
    m_suppressPrompts = FALSE;
    m_nScaleFactor = 0.0f;
    m_nWorldSectorMaxPolys = 0;
    m_nWorldSectorSize = 0.0f;
    m_maxPlaneCheck = 0;
    m_weldThreshold = 0.0f;
	m_triStripMesh = FALSE;
	m_maxSectorOverlap = 0.0f;
	m_noAlphaInOverlap = FALSE;
	m_limitUVs = FALSE;
	m_limitUVMax = 0;
	m_weldThresholdUV = 0.0f;
	m_backfaceNormals = FALSE;
	m_2SidedMaterials = FALSE;
	m_colorVertexPrelight = FALSE;
	m_weldVertices = FALSE;
	m_texturenameCase = -1;
	m_conditionGeometry = FALSE;
	m_exportNormals = FALSE;
	m_worldOffsetX = 0.0f;
	m_worldOffsetY = 0.0f;
	m_worldOffsetZ = 0.0f;
	m_displayReport = FALSE;
	m_generateReportFile = FALSE;
	//}}AFX_DATA_INIT
}


void CBspDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    //{{AFX_DATA_MAP(CBspDlg)
    DDX_Text(pDX, IDC_BSP_SCALEFACTOR, m_nScaleFactor);
    DDV_MinMaxFloat(pDX, m_nScaleFactor, 0.f, 1.e+025f);    
    DDX_Text(pDX, IDC_WORLDSECTOR_MAXPOLYS, m_nWorldSectorMaxPolys);
    DDX_Text(pDX, IDC_WORLDSECTOR_SIZE, m_nWorldSectorSize);
    DDX_Text(pDX, IDC_MAXPLANECHECK, m_maxPlaneCheck);
    DDX_Text(pDX, IDC_WELDTHRESHOLD, m_weldThreshold);
	DDX_Check(pDX, IDC_TRISTRIP, m_triStripMesh);
	DDX_Text(pDX, IDC_MAXSECTOROVERLAP, m_maxSectorOverlap);
	DDV_MinMaxFloat(pDX, m_maxSectorOverlap, 0.f, 100.f);
	DDX_Check(pDX, IDC_NOALPHAINOVERLAP, m_noAlphaInOverlap);
	DDX_Check(pDX, IDC_LIMITUVS, m_limitUVs);
	DDX_Text(pDX, IDC_LIMITUVSMAX, m_limitUVMax);
	DDX_Text(pDX, IDC_WELDTHRESHOLDUV, m_weldThresholdUV);
	DDX_Check(pDX, IDC_BSP2SIDEDNORMALS, m_backfaceNormals);
	DDX_Check(pDX, IDC_BSP2SIDEDMATS, m_2SidedMaterials);
	DDX_Check(pDX, IDC_COLORVERTEXPRELIGHT, m_colorVertexPrelight);
	DDX_Check(pDX, IDC_BSPWELDING, m_weldVertices);
	DDX_Radio(pDX, IDC_ORIGCASE, m_texturenameCase);
	DDX_Check(pDX, IDC_CONDGEOM, m_conditionGeometry);
	DDX_Check(pDX, IDC_WORLDNORMALS, m_exportNormals);
	DDX_Text(pDX, IDC_BSPOFFSETX, m_worldOffsetX);
	DDX_Text(pDX, IDC_BSPOFFSETY, m_worldOffsetY);
	DDX_Text(pDX, IDC_BSPOFFSETZ, m_worldOffsetZ);
	DDX_Check(pDX, IDC_BSPDISPLAYREPORT, m_displayReport);
	DDX_Check(pDX, IDC_BSPGENFILE, m_generateReportFile);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CBspDlg, CDialog)
    //{{AFX_MSG_MAP(CBspDlg)
    ON_BN_CLICKED(IDC_BSP_DEFAULT, OnBspDefault)
    ON_BN_CLICKED(IDC_BSP_SETDEFAULT, OnBspSetDefault)
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CBspDlg message handlers

void CBspDlg::OnBspDefault() 
{
    DWORD Disposition;
    HKEY SettingsKey;
    char buffer[256];    
    unsigned long size, value;

    RegCreateKeyEx (HKEY_CURRENT_USER, 
                    "Software\\Criterion\\RenderWare3\\3DSMax Exporter\\BSP Exporter", 0,
                    REG_NONE, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                    &SettingsKey, &Disposition);    
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Scale Factor", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_nScaleFactor = 1.0f;
        sprintf(buffer, "%f", m_nScaleFactor);
        RegSetValueEx (SettingsKey, "Scale Factor", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_nScaleFactor);
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "MaxWorldSectorPolyCount", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_nWorldSectorMaxPolys = 1024;
        RegSetValueEx (SettingsKey, "MaxWorldSectorPolyCount", 0, REG_DWORD, (unsigned char *)&m_nWorldSectorMaxPolys, 4);
    }
    else
    {
        m_nWorldSectorMaxPolys = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "MaxSectorSplitCheck", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_maxPlaneCheck = 50;
        RegSetValueEx (SettingsKey, "MaxSectorSplitCheck", 0, REG_DWORD, (unsigned char *)&m_maxPlaneCheck, 4);
    }
    else
    {
        m_maxPlaneCheck = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "TriStripMeshes", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_triStripMesh = FALSE;
        RegSetValueEx (SettingsKey, "TriStripMeshes", 0, REG_DWORD, (unsigned char *)&m_triStripMesh, 4);
    }
    else
    {
        m_triStripMesh = value;
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "MaxSectorSize", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_nWorldSectorSize = 10.0e+37f;
        sprintf(buffer, "%f", m_nWorldSectorSize);
        RegSetValueEx (SettingsKey, "MaxSectorSize", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_nWorldSectorSize);
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Weld Threshold", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_weldThreshold = 0.001f;
        sprintf(buffer, "%f", m_weldThreshold);
        RegSetValueEx (SettingsKey, "Weld Threshold", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_weldThreshold);
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Weld Threshold UV", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_weldThresholdUV = 0.001f;
        sprintf(buffer, "%f", m_weldThresholdUV);
        RegSetValueEx (SettingsKey, "Weld Threshold UV", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_weldThresholdUV);
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Max Sector Overlap", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_maxSectorOverlap = 25.0f;
        sprintf(buffer, "%f", m_maxSectorOverlap);
        RegSetValueEx (SettingsKey, "Max Sector Overlap", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_maxSectorOverlap);
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "No Alpha In Overlap", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_noAlphaInOverlap = FALSE;
        RegSetValueEx (SettingsKey, "No Alpha In Overlap", 0, REG_DWORD, (unsigned char *)&m_noAlphaInOverlap, 4);
    }
    else
    {
        m_noAlphaInOverlap = value;
    }    
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Limit UVs", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_limitUVs = FALSE;
        RegSetValueEx (SettingsKey, "Limit UVs", 0, REG_DWORD, (unsigned char *)&m_limitUVs, 4);
    }
    else
    {
        m_limitUVs = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Limit UV Max", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_limitUVMax = 16;
        RegSetValueEx (SettingsKey, "Limit UV Max", 0, REG_DWORD, (unsigned char *)&m_limitUVMax, 4);
    }
    else
    {
        m_limitUVMax = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export 2-Sided Materials", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_2SidedMaterials = FALSE;
        RegSetValueEx (SettingsKey, "Export 2-Sided Materials", 0, REG_DWORD, (unsigned char *)&m_2SidedMaterials, 4);
    }
    else
    {
        m_2SidedMaterials = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Backface Normals", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_backfaceNormals = FALSE;
        RegSetValueEx (SettingsKey, "Backface Normals", 0, REG_DWORD, (unsigned char *)&m_backfaceNormals, 4);
    }
    else
    {
        m_backfaceNormals = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Texture Name Case", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_texturenameCase = 0;        
        RegSetValueEx (SettingsKey, "Texture Name Case", 0, REG_DWORD, (unsigned char *)&m_texturenameCase, 4);
    }
    else
    {
        m_texturenameCase = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Condition Geometry", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_conditionGeometry = FALSE;        
        RegSetValueEx (SettingsKey, "Condition Geometry", 0, REG_DWORD, (unsigned char *)&m_conditionGeometry, 4);
    }
    else
    {
        m_conditionGeometry = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Apply Welding", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_weldVertices = FALSE;        
        RegSetValueEx (SettingsKey, "Apply Welding", 0, REG_DWORD, (unsigned char *)&m_weldVertices, 4);
    }
    else
    {
        m_weldVertices = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Export Normals", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_exportNormals = TRUE;
        RegSetValueEx (SettingsKey, "Export Normals", 0, REG_DWORD, (unsigned char *)&m_exportNormals, 4);
    }
    else
    {
        m_exportNormals = value;
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Global World Offset X", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_worldOffsetX = 0.0f;
        sprintf(buffer, "%f", m_worldOffsetX);
        RegSetValueEx (SettingsKey, "Global World Offset X", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_worldOffsetX);
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Global World Offset Y", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_worldOffsetY = 0.0f;
        sprintf(buffer, "%f", m_worldOffsetY);
        RegSetValueEx (SettingsKey, "Global World Offset Y", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_worldOffsetY);
    }
    size = 255;
    if (RegQueryValueEx (SettingsKey, "Global World Offset Z", NULL, NULL, (unsigned char *)buffer, &size) != ERROR_SUCCESS)
    {
        m_worldOffsetZ = 0.0f;
        sprintf(buffer, "%f", m_worldOffsetZ);
        RegSetValueEx (SettingsKey, "Global World Offset Z", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    }
    else
    {
        sscanf(buffer, "%f", &m_worldOffsetZ);
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Vertex Color Prelight", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_colorVertexPrelight = FALSE;
        RegSetValueEx (SettingsKey, "Vertex Color Prelight", 0, REG_DWORD, (unsigned char *)&m_colorVertexPrelight, 4);
    }
    else
    {
        m_colorVertexPrelight = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Generate Report File", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_generateReportFile = FALSE;
        RegSetValueEx (SettingsKey, "Generate Report File", 0, REG_DWORD, (unsigned char *)&m_generateReportFile, 4);
    }
    else
    {
        m_generateReportFile = value;
    }
    size = 4;
    if (RegQueryValueEx (SettingsKey, "Display Report", NULL, NULL, (unsigned char *)&value, &size) != ERROR_SUCCESS)
    {
        m_displayReport = FALSE;
        RegSetValueEx (SettingsKey, "Display Report", 0, REG_DWORD, (unsigned char *)&m_displayReport, 4);
    }
    else
    {
        m_displayReport = value;
    }

    RegCloseKey (SettingsKey);
      
    UpdateData(FALSE);
}

void CBspDlg::OnBspSetDefault() 
{
    DWORD Disposition;
    HKEY SettingsKey;
    char buffer[256];    

    UpdateData(TRUE);
    RegCreateKeyEx (HKEY_CURRENT_USER, 
                    "Software\\Criterion\\RenderWare3\\3DSMax Exporter\\BSP Exporter", 0,
                    REG_NONE, REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, 
                    &SettingsKey, &Disposition);    
    
    sprintf(buffer, "%f", m_nScaleFactor);
    RegSetValueEx (SettingsKey, "Scale Factor", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    RegSetValueEx (SettingsKey, "MaxWorldSectorPolyCount", 0, REG_DWORD, (unsigned char *)&m_nWorldSectorMaxPolys, 4);
    RegSetValueEx (SettingsKey, "MaxSectorSplitCheck", 0, REG_DWORD, (unsigned char *)&m_maxPlaneCheck, 4);
    RegSetValueEx (SettingsKey, "TriStripMeshes", 0, REG_DWORD, (unsigned char *)&m_triStripMesh, 4);
    sprintf(buffer, "%f", m_nWorldSectorSize);
    RegSetValueEx (SettingsKey, "MaxSectorSize", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    sprintf(buffer, "%f", m_weldThreshold);
    RegSetValueEx (SettingsKey, "Weld Threshold", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    sprintf(buffer, "%f", m_weldThresholdUV);
    RegSetValueEx (SettingsKey, "Weld Threshold UV", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    sprintf(buffer, "%f", m_maxSectorOverlap);
    RegSetValueEx (SettingsKey, "Max Sector Overlap", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    RegSetValueEx (SettingsKey, "No Alpha In Overlap", 0, REG_DWORD, (unsigned char *)&m_noAlphaInOverlap, 4);    
    RegSetValueEx (SettingsKey, "Limit UVs", 0, REG_DWORD, (unsigned char *)&m_limitUVs, 4);
    RegSetValueEx (SettingsKey, "Limit UV Max", 0, REG_DWORD, (unsigned char *)&m_limitUVMax, 4);
    RegSetValueEx (SettingsKey, "Export 2-Sided Materials", 0, REG_DWORD, (unsigned char *)&m_2SidedMaterials, 4);
    RegSetValueEx (SettingsKey, "Backface Normals", 0, REG_DWORD, (unsigned char *)&m_backfaceNormals, 4);
    RegSetValueEx (SettingsKey, "Texture Name Case", 0, REG_DWORD, (unsigned char *)&m_texturenameCase, 4);
    RegSetValueEx (SettingsKey, "Condition Geometry", 0, REG_DWORD, (unsigned char *)&m_conditionGeometry, 4);  
    RegSetValueEx (SettingsKey, "Apply Welding", 0, REG_DWORD, (unsigned char *)&m_weldVertices, 4);  
    RegSetValueEx (SettingsKey, "Export Normals", 0, REG_DWORD, (unsigned char *)&m_exportNormals, 4);
    sprintf(buffer, "%f", m_worldOffsetX);
    RegSetValueEx (SettingsKey, "Global World Offset X", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);    
    sprintf(buffer, "%f", m_worldOffsetY);
    RegSetValueEx (SettingsKey, "Global World Offset Y", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);
    sprintf(buffer, "%f", m_worldOffsetZ);
    RegSetValueEx (SettingsKey, "Global World Offset Z", 0, REG_SZ, (unsigned char *)buffer, strlen(buffer)+1);    
    RegSetValueEx (SettingsKey, "Vertex Color Prelight", 0, REG_DWORD, (unsigned char *)&m_colorVertexPrelight, 4);
    RegSetValueEx (SettingsKey, "Generate Report File", 0, REG_DWORD, (unsigned char *)&m_generateReportFile, 4);
    RegSetValueEx (SettingsKey, "Display Report", 0, REG_DWORD, (unsigned char *)&m_displayReport, 4);

    RegCloseKey (SettingsKey);    
}

BOOL CBspDlg::OnInitDialog() 
{
    string Version;
    CString ExistingTitle;

    CDialog::OnInitDialog();

    //set window text from version information
    SetWindowText(BSPExporterWindowTitle);
    
    OnBspDefault();
    
    //if suppressPrompts then simply click the OK button
    if (m_suppressPrompts) OnOK();

    return TRUE;  // return TRUE unless you set the focus to a control
                  // EXCEPTION: OCX Property Pages should return FALSE
}
